'use strict'

entityRegistry['module']['image'] = {
    extendedInfo: {
        displayName: 'Image',
        displayGroup: 'Core',
    },
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'image', displayName: 'Image', type: 'colorTexture', defaultValue: ''},
        { paramName: 'mode', displayName: 'Mode', type: 'string', defaultValue: 'set', uiOptions: { options: [{text:'Set', value:'set'}, {text:'Alpha', value:'alpha'}, {text:'Additive', value:'additive'}, {text:'Subtractive', value:'subtractive'}, {text:'Difference', value:'difference'}]}},
        { paramName: 'alpha', displayName: 'Alpha', type: 'float', defaultValue: 1},
        { paramName: 'position', displayName: 'Position', type: 'float2', defaultValue: [0, 0]},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                image,
                mode,
                alpha,
                position
            } = { ...config }

            const dstWidth = renderer.bufferWidth
            const dstHeight = renderer.bufferHeight
            const srcWidth = image.width
            const srcHeight = image.height

            const x1 = Math.floor((dstWidth-srcWidth)/2 + position[0])
            const x2 = x1 + srcWidth
            const y1 = Math.floor((dstHeight-srcHeight)/2 + position[1])
            const y2 = y1 + srcHeight

            if (x1 >= dstWidth || x2 < 0 || y1 >= dstHeight || y2 < 0) {
                return 
            }

            const startX = Math.max(x1, 0)
            const width = Math.min(x2, dstWidth) - startX
            const srcXOffset = Math.max(-x1,0)

            const startY = Math.max(y1, 0)
            const height = Math.min(y2, dstHeight) - startY
            const srcYOffset = -y1

            const srcImage = image.data
            const dstImage = renderer.canvasBuffer.data

            if (mode === 'set') {
                for (let y = startY; y < startY + height; ++y) {
                    let src = 0 + ((srcYOffset+y)*srcWidth + srcXOffset) * 4
                    let dst = 0 + (y*dstWidth + startX)*4
                    for (let x = 0; x < width; x++) {
                        dstImage[dst++] = srcImage[src++]
                        dstImage[dst++] = srcImage[src++]
                        dstImage[dst++] = srcImage[src++]
                        dstImage[dst++] = 255
                        src++
                    }
                }
            } else if (mode === 'alpha') {
                for (let y = startY; y < startY + height; ++y) {
                    let src = 0 + ((srcYOffset+y)*srcWidth + srcXOffset) * 4
                    let dst = 0 + (y*dstWidth + startX)*4
                    for (let x = 0; x < width; x++) {
                        const a = srcImage[src+3] / 255 * alpha
                        dstImage[dst] = lerp(dstImage[dst++], srcImage[src++], a)
                        dstImage[dst] = lerp(dstImage[dst++], srcImage[src++], a)
                        dstImage[dst] = lerp(dstImage[dst++], srcImage[src++], a)
                        dstImage[dst++] = 255
                        src++
                    }
                }
            } else if (mode === 'additive') {
                for (let y = startY; y < startY + height; ++y) {
                    let src = 0 + ((srcYOffset+y)*srcWidth + srcXOffset) * 4
                    let dst = 0 + (y*dstWidth + startX)*4
                    for (let x = 0; x < width; x++) {
                        dstImage[dst++] += srcImage[src++] * alpha
                        dstImage[dst++] += srcImage[src++] * alpha
                        dstImage[dst++] += srcImage[src++] * alpha
                        dstImage[dst++] = 255
                        src++
                    }
                }
            } else if (mode === 'subtractive') {
                for (let y = startY; y < startY + height; ++y) {
                    let src = 0 + ((srcYOffset+y)*srcWidth + srcXOffset) * 4
                    let dst = 0 + (y*dstWidth + startX)*4
                    for (let x = 0; x < width; x++) {
                        dstImage[dst++] -= srcImage[src++] * alpha
                        dstImage[dst++] -= srcImage[src++] * alpha
                        dstImage[dst++] -= srcImage[src++] * alpha
                        dstImage[dst++] = 255
                        src++
                    }
                }
            } else if (mode === 'difference') {
                for (let y = startY; y < startY + height; ++y) {
                    let src = 0 + ((srcYOffset+y)*srcWidth + srcXOffset) * 4
                    let dst = 0 + (y*dstWidth + startX)*4
                    for (let x = 0; x < width; x++) {
                        const a = srcImage[src+3] / 255 * alpha
                        dstImage[dst] = lerp(dstImage[dst], Math.abs(srcImage[src] - dstImage[dst]), a); dst++; src++
                        dstImage[dst] = lerp(dstImage[dst], Math.abs(srcImage[src] - dstImage[dst]), a); dst++; src++
                        dstImage[dst] = lerp(dstImage[dst], Math.abs(srcImage[src] - dstImage[dst]), a); dst++; src++
                        dstImage[dst++] = 255
                        src++
                    }
                }
            }
        }
    }
}
